% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_minicharts.R
\name{addMinicharts}
\alias{addMinicharts}
\alias{updateMinicharts}
\title{Add or update charts on a leaflet map}
\usage{
addMinicharts(map, lng, lat, data = 1, maxValues = NULL, type = "auto",
  fillColor = NULL, colorPalette = NULL, width = 30, height = 30,
  opacity = 1, showLabels = FALSE, labelStyle = NULL, labelText = NULL,
  transitionTime = 750, popup = NULL, layerId = NULL)

updateMinicharts(map, layerId, data = NULL, maxValues = NULL, type = NULL,
  fillColor = NULL, colorPalette = NULL, width = NULL, height = NULL,
  opacity = NULL, showLabels = NULL, labelStyle = NULL,
  labelText = NULL, transitionTime = NULL, popup = NULL)
}
\arguments{
\item{map}{A leaflet map object created with \code{\link[leaflet]{leaflet}}.}

\item{lng}{Longitude where to place the charts.}

\item{lat}{Lattitude where to place the charts.}

\item{data}{A numeric matrix with number of rows equal to the number of
elements in \code{lng} or \code{lat} and number of column equal to the
number of variables to represent.}

\item{maxValues}{maximal absolute values of the variables to represent.
It can be a vector with one value per column of \code{data} or a single
value. Using a single value enforces charts to use a unique scale for all
variables. If it is \code{NULL}, the maximum value of \code{data} is used.}

\item{type}{Type of chart. Possible values are \code{"bar"} for bar charts,
\code{"pie"} for pie charts, \code{"polar-area"} and \code{"polar-radius"}
for polar area charts where the values are represented respectively by the
area or the radius of the slices. Finally it can be equal to \code{"auto"},
the default. In this case, if there is only one variable to represent, the
chart will be a single circle, else it is a barchart.}

\item{fillColor}{Used only if data contains only one column. It is the color
used to fill the circles.}

\item{colorPalette}{Color palette to use when \code{data} contains more than
one column.}

\item{width}{maximal width of the created elements.}

\item{height}{maximal height of the created elements.}

\item{opacity}{Opacity of the chart.}

\item{showLabels}{Should values be displayed above chart elements.}

\item{labelStyle}{Character string containing CSS properties to apply to the
labels.}

\item{labelText}{character vector containing the text content of the charts.
Used only if \code{data} contains only one column.}

\item{transitionTime}{duration of the transitions when a property of a chart
is updated}

\item{popup}{Content of the popup bind to a given chart. This can be html
text.}

\item{layerId}{An ID variable. It is mandatoy when one wants to update some
chart.}
}
\value{
The modified leaflet map object.
}
\description{
these functions add or update minicharts in a leaflet map at given coordinates:
they can be bar charts, pie charts or polar charts where data is encoded
either by area or by radius.
}
\examples{
require(leaflet)
mymap <- leaflet() \%>\% addTiles() \%>\% addMinicharts(0, 0, data = 1:3, layerId = "c1")

mymap
mymap \%>\% updateMinicharts("c1", maxValues = 6)
mymap \%>\% updateMinicharts("c1", type="pie")

}
