% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layergroupconditional.R
\name{addLayerGroupConditional}
\alias{addLayerGroupConditional}
\title{addLayerGroupConditional}
\usage{
addLayerGroupConditional(map, groups = NULL, conditions = NULL)
}
\arguments{
\item{map}{A map widget object created from \code{\link[leaflet]{leaflet}}.}

\item{groups}{A character vector of layer group names already added to the map.
These layer groups will be conditionally displayed based on the specified \code{conditions}.}

\item{conditions}{A named list where:
- Each **name** is a JavaScript function (using \code{\link[leaflet]{JS}}) defining a condition for displaying a layer group.
- Each **value** corresponds to a layer group name (or names) from the \code{layers} parameter.
Example:
\preformatted{
  condition = list(
    "(zoomLevel) => zoomLevel < 4" = "group1",
    "(zoomLevel) => zoomLevel >= 4 && zoomLevel < 6" = "group2",
    "(zoomLevel) => zoomLevel >= 6" = c("group3", "group4")
  )
}}
}
\description{
addLayerGroupConditional
}
\examples{
library(leaflet)
library(sf)
library(leaflet.extras2)

breweries91 <- st_as_sf(breweries91)
lines <- st_as_sf(atlStorms2005)
polys <- st_as_sf(leaflet::gadmCHE)
groups <- c("atlStorms", "breweries", "gadmCHE")

leaflet() \%>\%
  addTiles() \%>\%
  # leafem::addMouseCoordinates() \%>\%
  addPolylines(data = lines, label = ~Name, group = groups[1]) \%>\%
  addCircleMarkers(data = breweries91, label = ~brewery, group = groups[2]) \%>\%
  addPolygons(data = polys, label = ~NAME_1, group = groups[3]) \%>\%
  addLayerGroupConditional(
    groups = groups,
    conditions = list(
      "(zoomLevel) => zoomLevel < 4" = groups[1],
      "(zoomLevel) => zoomLevel >= 4 & zoomLevel < 6 " = groups[2],
      "(zoomLevel) => zoomLevel >= 6" = groups[3]
    )
  ) \%>\%
  hideGroup(groups) \%>\%
  addLayersControl(
    overlayGroups = groups,
    options = layersControlOptions(collapsed = FALSE)
  )

}
\seealso{
\url{https://github.com/Solfisk/Leaflet.LayerGroup.Conditional?tab=readme-ov-file} for more details about the plugin.

Other LayerGroupConditional Plugin: 
\code{\link{clearConditionalLayers}()},
\code{\link{removeConditionalLayer}()}
}
\concept{LayerGroupConditional Plugin}
