% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sidebar.R
\name{sidebar_tabs}
\alias{sidebar_tabs}
\title{Create a Sidebar}
\usage{
sidebar_tabs(id = "sidebar", iconList = NULL, ...)
}
\arguments{
\item{id}{The id of the sidebar, which must match the \code{id} of
\code{\link{addSidebar}}. Default is \code{"sidebar"}}

\item{iconList}{A list of icons to be shown, when the sidebar is collapsed.
The list is required and must match the amount of \code{\link{sidebar_pane}}.}

\item{...}{The individual \code{\link{sidebar_pane}}.}
}
\value{
A \code{shiny.tag} with individual sidebar panes
}
\description{
Create a Sidebar
}
\examples{
\dontrun{
library(shiny)
runApp(paste0(system.file("examples", package = "leaflet.extras2"),
              "/sidebar_app.R"))
}
}
\references{
\url{https://github.com/Turbo87/sidebar-v2},
         \url{https://github.com/Turbo87/sidebar-v2/blob/master/doc/usage.md}
}
\seealso{
Other Sidebar Functions: 
\code{\link{addSidebar}()},
\code{\link{closeSidebar}()},
\code{\link{openSidebar}()},
\code{\link{removeSidebar}()},
\code{\link{sidebar_pane}()}
}
\concept{Sidebar Functions}
