% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openweather.R
\name{addOpenweatherTiles}
\alias{addOpenweatherTiles}
\title{Add OpenWeatherMap Tiles}
\usage{
addOpenweatherTiles(
  map,
  apikey = NULL,
  layers = NULL,
  group = NULL,
  layerId = NULL,
  opacity = 0.5,
  options = openweatherOptions()
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{apikey}{a valid OpenWeatherMap-API key. Get one from
\href{https://openweathermap.org/api}{here}.}

\item{layers}{character vector of layers you wish to add to the map. The
following layers are currently possible \code{c("clouds", "cloudsClassic",
"precipitation", "precipitationClassic", "rain", "rainClassic", "snow",
"pressure", "pressureContour", "temperature", "wind")}.}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{layerId}{the layer id}

\item{opacity}{opacity of the layer}

\item{options}{List of further options. See \code{\link{openweatherOptions}}}
}
\value{
the new \code{map} object
}
\description{
Add OpenWeatherMap Tiles
}
\note{
Out of the box a legend image is only available for Pressure,
  Precipitation Classic, Clouds Classic, Rain Classic, Snow, Temperature and
  Wind Speed. Please add your own images if you need some more.
}
\examples{
\dontrun{
library(leaflet)
library(leaflet.extras2)

Sys.setenv("OPENWEATHERMAP" = 'Your_API_Key')

leaflet()  \%>\%
  addTiles() \%>\% setView(9, 50, 6) \%>\%
  addOpenweatherTiles(layers = "wind")
}
}
\references{
\url{https://github.com/trafficonese/leaflet-openweathermap}
}
\seealso{
Other Openweathermap Functions: 
\code{\link{addOpenweatherCurrent}()},
\code{\link{openweatherCurrentOptions}()},
\code{\link{openweatherOptions}()}
}
\concept{Openweathermap Functions}
