% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{addHeatmap}
\alias{addHeatmap}
\alias{addGeoJSONHeatmap}
\alias{addKMLHeatmap}
\alias{addCSVHeatmap}
\alias{addGPXHeatmap}
\alias{removeHeatmap}
\alias{clearHeatmap}
\title{Add a heatmap}
\usage{
addHeatmap(
  map,
  lng = NULL,
  lat = NULL,
  intensity = NULL,
  layerId = NULL,
  group = NULL,
  minOpacity = 0.05,
  max = 1,
  radius = 25,
  blur = 15,
  gradient = NULL,
  cellSize = NULL,
  data = leaflet::getMapData(map)
)

addGeoJSONHeatmap(
  map,
  geojson,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  minOpacity = 0.05,
  max = 1,
  radius = 25,
  blur = 15,
  gradient = NULL,
  cellSize = NULL
)

addKMLHeatmap(
  map,
  kml,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  minOpacity = 0.05,
  max = 1,
  radius = 25,
  blur = 15,
  gradient = NULL,
  cellSize = NULL
)

addCSVHeatmap(
  map,
  csv,
  csvParserOptions,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  minOpacity = 0.05,
  max = 1,
  radius = 25,
  blur = 15,
  gradient = NULL,
  cellSize = NULL
)

addGPXHeatmap(
  map,
  gpx,
  layerId = NULL,
  group = NULL,
  intensityProperty = NULL,
  minOpacity = 0.05,
  max = 1,
  radius = 25,
  blur = 15,
  gradient = NULL,
  cellSize = NULL
)

removeHeatmap(map, layerId)

clearHeatmap(map)
}
\arguments{
\item{map}{the map widget.}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{intensity}{intensity of the heat. A vector of numeric values or a formula.}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link{clearGroup}} and \code{\link{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{minOpacity}{minimum opacity at which the heat will start}

\item{max}{maximum point intensity. The default is \code{1.0}}

\item{radius}{radius of each "point" of the heatmap.  The default is
\code{25}.}

\item{blur}{amount of blur to apply.  The default is \code{15}.
\code{blur=1} means no blur.}

\item{gradient}{palette name from \code{RColorBrewer} or an array of
of colors to be provided to \code{\link{colorNumeric}}, or
a color mapping function returned from \code{colorNumeric}}

\item{cellSize}{the cell size in the grid. Points which are closer
than this may be merged. Defaults to `radius / 2`.s
Set to `1` to do almost no merging.}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}

\item{geojson}{The geojson or topojson url or contents as string.}

\item{intensityProperty}{The property to use for determining the intensity at a point.
Can be a "string" or a JS function, or NULL.}

\item{kml}{The KML url or contents as string.}

\item{csv}{The CSV url or contents as string.}

\item{csvParserOptions}{options for parsing the CSV.
Use \code{\link{csvParserOptions}}() to supply csv parser options.}

\item{gpx}{The GPX url or contents as string.}
}
\description{
Add a heatmap

Adds a heatmap with data from a GeoJSON/TopoJSON file/url

Adds a heatmap with data from a KML file/url

Adds a heatmap with data from a CSV file/url

Adds a heatmap with data from a GPX file/url

removes the heatmap

clears the heatmap
}
\examples{
leaflet(quakes) \%>\%
  addProviderTiles(providers$CartoDB.DarkMatter) \%>\%
  setView(178, -20, 5) \%>\%
  addHeatmap(
    lng = ~long, lat = ~lat, intensity = ~mag,
    blur = 20, max = 0.05, radius = 15
  )

## for more examples see
# browseURL(system.file("examples/heatmaps.R", package = "leaflet.extras"))
kml <- readr::read_file(
  system.file("examples/data/kml/crimes.kml.zip", package = "leaflet.extras")
)

leaflet() \%>\%
  setView(-77.0369, 38.9072, 12) \%>\%
  addProviderTiles(providers$CartoDB.Positron) \%>\%
  addKMLHeatmap(kml, radius = 7) \%>\%
  addKML(
    kml,
    markerType = "circleMarker",
    stroke = FALSE, fillColor = "black", fillOpacity = 1,
    markerOptions = markerOptions(radius = 1)
  )

## for more examples see
# browseURL(system.file("examples/KML.R", package = "leaflet.extras"))
}
