% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{updateLayersControl}
\alias{updateLayersControl}
\title{Update the layer controls when adding layers to an existing map.}
\usage{
updateLayersControl(
  map,
  addBaseGroups = character(0),
  addOverlayGroups = character(0),
  position = "topleft",
  ...
)
}
\arguments{
\item{map}{A \code{leaflet} or \code{mapview} map.}

\item{addBaseGroups}{group names of base layers to be added to layers control.}

\item{addOverlayGroups}{group names of overlay layers to be added to layers control.}

\item{position}{position of control: "topleft", "topright", "bottomleft", or "bottomright".}

\item{...}{Further arguments passed to \code{\link[leaflet]{addLayersControl}}.}
}
\value{
A leaflet \code{map} object.
}
\description{
When adding additional base layers or overlay layers to an existing map,
\code{updateLayersControl} will either update the existing layers control or
add a new one if map has none.
}
\examples{
library(leaflet)

map = leaflet() \%>\%
        addProviderTiles("OpenStreetMap", group = "OSM") \%>\%
        addProviderTiles("CartoDB.DarkMatter", group = "dark") \%>\%
        addCircleMarkers(data = breweries91, group = "brew")

map # no layers control

map \%>\%
  updateLayersControl(addBaseGroups = c("OSM", "dark"),
                      addOverlayGroups = "brew")

}
