% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.distance}
\alias{s.distance}
\title{Get the Distances Between Variables}
\usage{
s.distance(
  data,
  distance = "correlation",
  correlation = "pearson",
  checkNan = TRUE
)
}
\arguments{
\item{data}{A numeric matrix with variables in the columns.}

\item{distance}{Character string specifying the type of distance.
It can be \code{correlation}, \code{absCorrelation}, \code{euclidean}, \code{manhattan}, or \code{maximum}.}

\item{correlation}{Character string specifying the type of correlation if \code{distance} is correlation.
It can be \code{pearson} or \code{spearman}.}

\item{checkNan}{Logical value indicating whether to check for \code{NA}s (and omit them if any exist).}
}
\value{
A symmetric matrix (lower triangle as a vector).
}
\description{
This function calculates the distances between the columns of a numeric matrix.
}
\details{
The main purpose of exporting this statistics helper method is to show the inner calculations of the package.
}
\examples{
n <- 10
data <- data.frame(x = rnorm(n), y = rnorm(n), z = rnorm(n))
distances <- s.distance(data)

}
