% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get.items.modelcheck}
\alias{get.items.modelcheck}
\title{Set Options to Exclude a Model Subset}
\usage{
get.items.modelcheck(
  estimation = TRUE,
  maxConditionNumber = Inf,
  minObsCount = 0,
  minDof = 0,
  minOutSim = 0,
  minR2 = -Inf,
  maxAic = Inf,
  maxSic = Inf,
  prediction = FALSE,
  predictionBoundMultiplier = 4
)
}
\arguments{
\item{estimation}{If \code{TRUE}, the model is estimated with all data and is ignored if this estimation fails. If \code{FALSE}, you might get a 'best model' that cannot be estimated.}

\item{maxConditionNumber}{A number used to ignore an estimation that has a high condition number (if implemented in the search).}

\item{minObsCount}{An integer used to ignore an estimation where the number of observations (after dealing with \code{NA}) is low. Use 0 to disable this check.}

\item{minDof}{An integer used to ignore an estimation with low degrees of freedom (equation-wise). Use 0 to disable this check.}

\item{minOutSim}{An integer used to ignore estimations with a low number of out-of-sample simulations (if implemented in the search).}

\item{minR2}{A number used to ignore estimations with a low value for 'R2' (if implemented in the search).}

\item{maxAic}{A number used to ignore estimations with a high 'AIC' (if implemented in the search).}

\item{maxSic}{A number used to ignore estimations with a high 'SIC' (if implemented in the search).}

\item{prediction}{If \code{TRUE}, model data is predicted given all data and is ignored if this process fails. If \code{FALSE}, you might get a 'best model' that cannot be used for prediction.}

\item{predictionBoundMultiplier}{A positive number used to create a bound and check predictions.
The bound is created by multiplying this value by the average growth rate of the data.
A model is ignored if its prediction lies outside of this bound. Use zero to disable this check.}
}
\value{
A list with the given options.
}
\description{
Use this function to determine which models should be skipped in the search process.
}
