% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{estim.varma}
\alias{estim.varma}
\title{Estimate a VARMA Model}
\usage{
estim.varma(
  y,
  x = NULL,
  params = NULL,
  seasonsCount = 0,
  addIntercept = TRUE,
  lbfgsOptions = get.options.lbfgs(),
  olsStdMultiplier = 2,
  pcaOptionsY = NULL,
  pcaOptionsX = NULL,
  maxHorizon = 0,
  newX = NULL,
  simFixSize = 0,
  simHorizons = NULL,
  simUsePreviousEstim = TRUE,
  simMaxConditionNumber = Inf,
  simTransform = NULL,
  printMsg = FALSE
)
}
\arguments{
\item{y}{A matrix of endogenous data with variables in the columns.}

\item{x}{A matrix of exogenous data with variables in the columns. It can be \code{NULL}.}

\item{params}{An integer vector that determines the values for the parameters of the VARMA model: \code{(p,d,q,P,D,Q)}. If \code{NULL}, \code{c(1,0,0,0,0,0)} is used.}

\item{seasonsCount}{An integer value representing the number of observations per unit of time.}

\item{addIntercept}{If \code{TRUE}, an intercept is automatically added to x.}

\item{lbfgsOptions}{A list containing L-BFGS optimization options.
Use \link{get.options.lbfgs} function for initialization.}

\item{olsStdMultiplier}{A number used as a multiplier for the standard deviation of OLS, used for restricting maximum likelihood estimation.}

\item{pcaOptionsY}{A list of options to use principal components of \code{y}, instead of the actual values. Set to \code{NULL} to disable. Use \code{\link[=get.options.pca]{get.options.pca()}} for initialization.}

\item{pcaOptionsX}{A list of options to use principal components of \code{x}, instead of the actual values. Set to \code{NULL} to disable. Use \code{\link[=get.options.pca]{get.options.pca()}} for initialization.}

\item{maxHorizon}{An integer representing the maximum prediction horizon. Set to zero to disable prediction.}

\item{newX}{A matrix containing new exogenous variables to be used in predictions. Its columns must be the same as \code{x}.}

\item{simFixSize}{An integer that determines the number of out-of-sample simulations. Use zero to disable simulation.}

\item{simHorizons}{An integer vector representing the prediction horizons to be used in out-of-sample simulations. See also \code{\link[=get.options.metric]{get.options.metric()}}.}

\item{simUsePreviousEstim}{If \code{TRUE}, parameters are initialized only in the first step of the simulation. The initial values of the n-th simulation (with one more observation) are the estimations from the previous step.}

\item{simMaxConditionNumber}{A number representing the maximum value for the condition number in simulation.}

\item{simTransform}{Use a character string (e.g. \code{exp} for exponential function) or a function to transform data before calculating RMSE, MAE, RMSPE, MAPE, CRPS metrics. To disable this feature, use \code{NULL}.}

\item{printMsg}{Set to \code{TRUE} to enable printing some details.}
}
\value{
A nested list with the following items:
\item{counts}{Information about different aspects of the estimation such as the number of observation, number of exogenous variables, etc.}
\item{estimations}{Estimated coefficients, standard errors, z-statistics, p-values, etc.}
\item{metrics}{Value of different goodness of fit and out-of-sample performance metrics. }
\item{prediction}{Information on the predicted values.}
\item{simulation}{Information on the simulations. }
\item{info}{Some other general information.}
}
\description{
Use this function to estimate a Vector Autoregressive Moving Average model.
}
\details{
Seasonal Integrated Vector Autoregressive Moving-Average is used for predicting time series variables.
Its formula is:
\deqn{
\Delta^d \Delta_s^D y_t = c + \sum_{i=1}^p A_i y_{t-i} +
                              \sum_{i=1}^q B_i \epsilon_{t-i}  +
                              C x_t  +
                              \sum_{i=1}^P A_{is} y_{t-is} +
                              \sum_{i=1}^Q B_{is} \epsilon_{t-is} +
                              \epsilon_t,
}
where \eqn{y_t} is the vector of endogenous variables, \eqn{x_t} is the vector exogenous variables, \eqn{s} is the number of seasons and \eqn{(p,d,q,P,D,Q)} are the lag structure of the model.
Furthermore, \eqn{c,\;C,\;A_i} and \eqn{B_i} for all available \eqn{i} are the parameters of the model.
We use maximum likelihood estimator to estimate the parameters of the model.
If \eqn{B_i} coefficients are not zero, identification restrictions are necessary to ensure that the model is uniquely identifiable.
In the current implementation, this function restricts \eqn{B_i} coefficients to be diagonal.

Note that the main purpose of exporting this method is to show the inner calculations of the search process in \link{search.varma} function.
}
\examples{
# Example 1 (simulation, ARMA):
num_eq <- 1L
num_ar <- 2L
num_ma <- 1L
num_exo <- 1L
sample <- sim.varma(num_eq, arList = num_ar, maList = num_ma, exoCoef = num_exo, nObs = 100)
# estimate:
fit <- estim.varma(sample$y, sample$x, params = c(num_ar, 0, num_ma, 0, 0, 0))
# split coefficient matrix:
get.varma.params(fit$estimations$coefs, numAR = num_ar, numMA = num_ma, numExo = num_exo)

# Example 2 (simulation, VARMA):
num_eq <- 3L
num_ar <- 2L
num_ma <- 1L
num_ma <- 1L
num_exo <- 2L
sample <- sim.varma(num_eq, arList = num_ar, maList = num_ma, exoCoef = num_exo, nObs = 100)
# estimate:
fit <- estim.varma(sample$y, sample$x, params = c(num_ar, 0, num_ma, 0, 0, 0))
# split coefficient matrix:
get.varma.params(fit$estimations$coefs, numAR = num_ar, numMA = num_ma, numExo = num_exo)
}
\seealso{
\link{search.varma}, \link{search.varma.stepwise}
}
