% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_metrics}
\alias{calculate_metrics}
\title{Reconstruction metrics}
\usage{
calculate_metrics(sim, obs, z, norm.fun = mean)
}
\arguments{
\item{sim}{A vector of reconstruction output for instrumental period}

\item{obs}{A vector of all observations}

\item{z}{A vector of left out indices in cross validation}

\item{norm.fun}{The function (unquoted name) used to calculate the normalizing constant. Default is \code{mean()}, but other functions such as \code{sd()} can also be used. THe function must take a vector as input and return a scalar as output, and must have an argument \code{na.rm = TRUE}.}
}
\value{
A named vector of performance metrics
}
\description{
Calculate reconstruction metrics from the instrumental period
}
\examples{
calculate_metrics(rnorm(100), rnorm(100), z = 1:10)
calculate_metrics(rnorm(100), rnorm(100), z = 1:10, norm.fun = sd)
}
