% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDS_reconstruction.R
\name{LDS_EM_restart}
\alias{LDS_EM_restart}
\title{Learn LDS model with multiple initial conditions}
\usage{
LDS_EM_restart(y, u, v, init, niter = 1000, tol = 1e-05, return.init = TRUE)
}
\arguments{
\item{y}{Observation matrix (may need to be normalized and centered before hand) (q rows, T columns)}

\item{u}{Input matrix for the state equation (m_u rows, T columns)}

\item{v}{Input matrix for the output equation (m_v rows, T columns)}

\item{init}{A list of initial parameters for the EM search. See \link{make_init}.}

\item{niter}{Maximum number of iterations, default 1000}

\item{tol}{Tolerance for likelihood convergence, default 1e-5. Note that the log-likelihood is normalized by dividing by the number of observations.}

\item{return.init}{Indicate whether the initial condition that results in the highest}
}
\value{
a list as produced by \link{LDS_EM}. If return.init is true, a vector of initial condition is included in the list as well.
}
\description{
This is the backend computation for \link{LDS_reconstruction}. You should not use this directly.
}
