% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sldhmm-class.R
\docType{class}
\name{sldhmm-class}
\alias{sldhmm-class}
\title{The sldhmm class}
\description{
This S4 class is the stable lambda object class for ldhmm package
It uses the stable lambda distribution for more granular fit
}
\section{Slots}{

\describe{
\item{\code{call}}{The match.call slot}

\item{\code{m}}{numeric, length 1, number of states}

\item{\code{dist.name}}{character, name of distribution, default is "sld".
This is in preparation as a more generic class container in the future.}

\item{\code{t}}{numeric, the time period}

\item{\code{param.nbr}}{numeric, number of parameters, default is 4.}

\item{\code{param}}{matrix, natural parameters for sld objects, size of states times param.nbr.
Each row should be 4-parameter sequences: \code{(mu, nu0, theta, convo)}.}

\item{\code{gamma}}{matrix, the transition probability matrix, must be m by m.}

\item{\code{delta}}{numeric, the initial distribution for each state, default is \code{NULL}.}

\item{\code{stationary}}{logical, specify whether the initial distribution is stationary or not,
default is \code{TRUE}.}

\item{\code{mle.optimizer}}{character, the MLE optimizer. Currently it is just set to "nlm".}

\item{\code{return.code}}{numeric, the return code from the MLE optimizer.}

\item{\code{iterations}}{numeric, number of iterations MLE optimizer takes.}

\item{\code{mllk}}{numeric, the final mllk value.}

\item{\code{AIC}}{numeric, the final AIC.}

\item{\code{BIC}}{numeric, the final BIC.}

\item{\code{observations}}{numeric, stores the observations post optimization}

\item{\code{states.prob}}{matrix, stores the state probabilities post optimization}

\item{\code{states.local}}{numeric, stores the local decoding states post optimization}

\item{\code{states.global}}{numeric, stores the global decoding states post optimization (Viterbi)}

\item{\code{states.local.stats}}{matrix, stores the statistics of local states post optimization}

\item{\code{states.global.stats}}{matrix, stores the statistics of global states post optimization}
}}

\keyword{class}
\keyword{constructor}
