% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{sliouv_m}
\alias{sliouv_m}
\title{Multiple marginal survival function for Liouville copulas}
\usage{
sliouv_m(x, family, alphavec, theta)
}
\arguments{
\item{x}{sample from copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}

\item{theta}{parameter of the corresponding Archimedean copula}
}
\value{
a matrix of same length as \code{x} with the survival probabilities
}
\description{
To apply different parameters (i.e. treat margins simultaneously)
}
\examples{
x <- rliouv(n = 100, family = "gumbel", alphavec <- c(2,3), theta = 2)
sliouv_m(x, family="gumbel", alphavec=c(2,3), theta=2)
all(sliouv_m(x, family="gumbel", alphavec=c(2,3), theta=2)[,1]-
  sliouvm(x[,1], family="gumbel", alpha=2, theta=2)==0)
}

