% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{pliouvm}
\alias{pliouvm}
\title{Marginal distribution function for Liouville copula}
\usage{
pliouvm(x, family, alpha, theta)
}
\arguments{
\item{x}{sample from copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alpha}{marginal allocation parameter (must be integer)}

\item{theta}{parameter of the corresponding Archimedean copula}
}
\value{
a vector of same length as \code{x} with the quantiles
}
\description{
Calls \code{sliouvm} to return cdf
}
\examples{
x <- rliouv(n = 100, family = "gumbel", alphavec <- c(2,3), theta = 2)
pliouvm(x[,1], family="gumbel", alpha=alphavec[1], theta=2)
}

