% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{liouv.maxim.mm}
\alias{liouv.maxim.mm}
\title{Maximize copula likelihood function for Liouville copulas via methods of moments}
\usage{
liouv.maxim.mm(data, family, boundary = NULL, lattice.mat = NULL,
  return_all = FALSE, MC.approx = T)
}
\arguments{
\item{data}{sample matrix from a Liouville copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"} or \code{"gumbel"}}

\item{boundary}{vector of endpoints for search of Dirichlet allocation parameters. Either \code{boundary} or \code{lattice.mat} can be supplied}

\item{lattice.mat}{matrix of tuples of Dirichlet allocation parameters at which to evaluate the likelihood}

\item{return_all}{should all results (as list) or only maximum value be returned. Defaults to \code{FALSE}}

\item{MC.approx}{whether to use Monte-Carlo approximation for the inverse survival function (default is \code{TRUE})}
}
\value{
a list with values of theta and Dirichlet and maximum found. Gives index
}
\description{
A wrapper to \code{optim} using the methods of moments to maxime pointwise given every \code{alphavec} over a grid.
Returns the maximum for \code{alphavec} and \code{theta}
}
\examples{
data <- rliouv(n=1000, family="gumbel", alphavec=c(1,2), theta=2)
liouv.maxim.mm(data=data, family="gumbel", boundary=c(3,3),return_all=TRUE)
lattice.mat <- t(combn(1:3,2))
liouv.maxim.mm(data=data, family="gumbel", lattice.mat=lattice.mat, return_all=FALSE)
}

