% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_lcc.R
\name{time_lcc}
\alias{time_lcc}
\title{Regular sequence for the time variable}
\usage{
time_lcc(time, from, to, n)
}
\arguments{
\item{time}{unique values of time variable}

\item{from}{the starting (minimal) value of time variable.}

\item{to}{the end (maximal) value of time variable.}

\item{n}{an integer specifying the desired length of the
sequence. Generally, \code{n} between 30 and 50 is adequate.}
}
\description{
An list specifying control arguments to generate a
  regular sequence for the time variable returned by the function
  \code{time_lcc}, which is used to constructed the LCC, LPC and LA
  curves and its simultaneous confidence intervals. Default is
  \code{NULL}.
}
\examples{
data(hue)
attach(hue)
time_lcc(time=Time, from=min(Time), to=max(Time), n=30)
detach(hue)

}
\keyword{internal}
