% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_control_parameters.R
\name{write_control_parameters}
\alias{write_control_parameters}
\title{Function to find and write the best control parameters.}
\usage{
write_control_parameters(x, path_control_files)
}
\arguments{
\item{x}{- dataset containing the trading results for one trading robot}

\item{path_control_files}{- path where control parameters will be saved}
}
\value{
Function writes best control parameters to be used by the Reinforcement Learning Function
}
\description{
This function is supposed to run on a weekly basis. Purpose of this function is to perform RL and
trading simulation and find out the best possible control parameters for the RL function.
}
\details{
Function is used by the R script Adapt_RL_control.R
}
\examples{

\donttest{
#test lasts 15 sec:
library(tidyverse)
library(ReinforcementLearning)
library(magrittr)
data(data_trades)
write_control_parameters(data_trades, path_control_files = tempfile())

}

}
\author{
(C) 2019 Vladimir Zhbanko
}
