% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_command_via_csv.R
\name{write_command_via_csv}
\alias{write_command_via_csv}
\title{Write csv files with indicated commands to the external system}
\usage{
write_command_via_csv(x, path_terminal = "",
  fileName = "SystemControl")
}
\arguments{
\item{x}{- dataframe object with resulting command e.g. 1 - enable; 0 - disable}

\item{path_terminal}{- path to the terminal}

\item{fileName}{- desired control file prefix e.g. 'SystemControl'}
}
\value{
Function is writing multiple files e.g. 'SystemControl8139124.csv' to the Sandbox

typical content of the file:
"Magic","IsEnabled"
8139124,1
}
\description{
Function is capable to read the data and  writing multiple files e.g. 'SystemControl8139124.csv'
}
\examples{


library(tidyverse)
library(lubridate)
library(lazytrade)
DFT1 <- import_data(trade_log_file = system.file("extdata",
                                                 "OrdersResultsT1.csv",
                                                 package = "lazytrade"),
                    demo_mode = TRUE)

dir <- normalizePath(tempdir(),winslash = "/")
DFT1 \%>\%
group_by(MagicNumber) \%>\% select(MagicNumber) \%>\% mutate(IsEnabled = 0) \%>\%
# write commands to disable/enable systems
write_command_via_csv(path_terminal = file.path(dir))




}
\author{
(C) 2019 Vladimir Zhbanko
}
