% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyMatrices.R
\name{lazyMatrix}
\alias{lazyMatrix}
\alias{as.lazyMatrix}
\alias{lazymat}
\title{Lazy matrices}
\usage{
as.lazyMatrix(x)

lazymat(x, dim = NULL)
}
\arguments{
\item{x}{a numeric matrix, a numeric vector, a \code{lazyVector} object, or 
a \code{lazyMatrix} object}

\item{dim}{ignored if \code{x} is a (possibly lazy) matrix; otherwise, i.e. 
if \code{x} is a (possibly lazy) vector, then \code{dim} must be 
\code{NULL} or a vector of two integers, and \code{NULL} is equivalent
to \code{c(length(x), 1)} (a column matrix)}
}
\value{
An object of class \code{lazyMatrix}.
}
\description{
Create a lazy matrix.
}
\examples{
library(lazyNumbers)
M <- lazymat(toeplitz(c(1, 2)))
as.double(M + M)
as.double(M * M)
as.double(M \%*\% M)
}
