% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer.R
\name{lawn_buffer}
\alias{lawn_buffer}
\title{Buffer a feature}
\usage{
lawn_buffer(input, dist, units = "kilometers", lint = FALSE)
}
\arguments{
\item{input}{A \link{data-Feature} or \link{data-FeatureCollection}}

\item{dist}{(integer/numeric) Distance used to buffer the input.}

\item{units}{(character) Units of the \code{dist} argument.  Can be miles, feet,
kilometers (default), meters, or degrees.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\description{
Calculates a buffer for input features for a given radius.
}
\examples{
# From a Point
pt <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
    "type": "Point",
    "coordinates": [-90.548630, 14.616599]
  }
}'
lawn_buffer(pt, 5)

# From a FeatureCollection
dat <- lawn_random(n = 100)
lawn_buffer(dat, 100)

# From a Feature
dat <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
     "type": "Polygon",
     "coordinates": [[
       [-112.072391,46.586591],
       [-112.072391,46.61761],
       [-112.028102,46.61761],
       [-112.028102,46.586591],
       [-112.072391,46.586591]
     ]]
   }
}'
lawn_buffer(dat, 1, "miles")

# buffer a point
lawn_buffer(lawn_point(c(-74.50,40)), 100, "meters")

}
\seealso{
Other transformations: 
\code{\link{lawn_bezier}()},
\code{\link{lawn_concave}()},
\code{\link{lawn_convex}()},
\code{\link{lawn_difference}()},
\code{\link{lawn_intersect}()},
\code{\link{lawn_merge}()},
\code{\link{lawn_simplify}()},
\code{\link{lawn_union}()}
}
\author{
Jeff Hollister \email{hollister.jeff@epa.gov}
}
\concept{transformations}
