% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{lawn_collect}
\alias{lawn_collect}
\title{Collect method}
\usage{
lawn_collect(polygons, points, in_field, out_field, lint = FALSE)
}
\arguments{
\item{polygons}{a FeatureCollection of \code{\link{data-Polygon}} features}

\item{points}{a FeatureCollection of \code{\link{data-Point}} features}

\item{in_field}{(character) the field in input data to analyze}

\item{out_field}{(character) the field in which to store results}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
A FeatureCollection of \code{\link{data-Polygon}} features with
properties listed as \code{out_field}
}
\description{
Given an inProperty on points and an outProperty for polygons,
this finds every point that lies within each polygon, collects the
inProperty values from those points, and adds them as an array to
outProperty on the polygon.
}
\examples{
ex_polys <- lawn_data$polygons_aggregate
ex_pts <- lawn_data$points_aggregate
res <- lawn_collect(ex_polys, ex_pts, 'population', 'stuff')
res$type
res$features
res$features$properties

}
\author{
Jeff Hollister \email{hollister.jeff@epa.gov}
}
\seealso{
Other aggregations: \code{\link{lawn_average}},
  \code{\link{lawn_count}}, \code{\link{lawn_deviation}},
  \code{\link{lawn_max}}, \code{\link{lawn_median}},
  \code{\link{lawn_min}}, \code{\link{lawn_sum}},
  \code{\link{lawn_variance}}
}

