% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-modelsearch2.R
\name{getNewModel}
\alias{getNewModel}
\alias{getNewModel.modelsearch2}
\title{Extract the Model that Has Been Retains by the modelsearch2.}
\usage{
getNewModel(object, step)

\method{getNewModel}{modelsearch2}(object, step = nStep(object))
}
\arguments{
\item{object}{a \code{modelsearch2} object.}

\item{step}{[integer >=0] the step at which the model should be extracted.
0 returns the initial model, i.e. before adding any links.}
}
\value{
A \code{lvmfit} object.
}
\description{
Extract the model that has been retained by modelsearch2.
}
\examples{
\dontrun{
mSim <- lvm(Y~G+X1+X2)
addvar(mSim) <- ~Z1+Z2+Z3+Z4+Z5+Z6

set.seed(10)
df.data <- lava::sim(mSim, 1e2)

mBase <- lvm(Y~G)
addvar(mBase) <- ~X1+X2+Z1+Z2+Z3+Z4+Z5+Z6
e.lvm <- estimate(mBase, data = df.data)
res <- modelsearch2(e.lvm, method.p.adjust = "holm")
getNewModel(res)
}
}
\concept{extractor}
\concept{modelsearch}
