% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.default.R
\name{sim.default}
\alias{sim.default}
\alias{summary.sim}
\title{Wrapper function for mclapply}
\usage{
\method{sim}{default}(x = NULL, R = 100, f = NULL, colnames = NULL,
  messages = 1L, mc.cores, blocksize = 2L * mc.cores, cl, type = 1L,
  seed = NULL, ...)
}
\arguments{
\item{x}{function or 'sim' object}

\item{R}{Number of replications}

\item{f}{Optional function (i.e., if x is a matrix)}

\item{colnames}{Optional column names}

\item{messages}{Messages}

\item{mc.cores}{Number of cores to use}

\item{blocksize}{Split computations in blocks}

\item{cl}{(optional) cluster to use for parallelization}

\item{type}{type=0 is an alias for messages=1,mc.cores=1,blocksize=R}

\item{seed}{(optional) Seed (needed with cl=TRUE)}

\item{...}{Additional arguments to (mc)mapply}
}
\description{
Wrapper function for mclapply
}
\examples{
m <- lvm(y~x+e)
distribution(m,~y) <- 0
distribution(m,~x) <- uniform.lvm(a=-1.1,b=1.1)
transform(m,e~x) <- function(x) (1*x^4)*rnorm(length(x),sd=1)

onerun <- function(iter=NULL,...,n=2e3,b0=1,idx=2) {
    d <- sim(m,n,p=c("y~x"=b0))
    l <- lm(y~x,d)
    res <- c(coef(summary(l))[idx,1:2],
             confint(l)[idx,],
             estimate(l,only.coef=TRUE)[idx,2:4])
    names(res) <- c("Estimate","Model.se","Model.lo","Model.hi",
                    "Sandwich.se","Sandwich.lo","Sandwich.hi")
    res
}
val <- sim(onerun,R=10,b0=1,messages=0,mc.cores=1)
val

val <- sim(val,R=40,b0=1,mc.cores=1) ## append results
summary(val,estimate=c(1,1),confint=c(3,4,6,7),true=c(1,1))

summary(val,estimate=c(1,1),se=c(2,5),names=c("Model","Sandwich"))
summary(val,estimate=c(1,1),se=c(2,5),true=c(1,1),names=c("Model","Sandwich"),confint=TRUE)

if (interactive()) {
    plot(val,estimate=1,c(2,5),true=1,names=c("Model","Sandwich"),polygon=FALSE)
    plot(val,estimate=c(1,1),se=c(2,5),main=NULL,
         true=c(1,1),names=c("Model","Sandwich"),
         line.lwd=1,density.col=c("gray20","gray60"),
         rug=FALSE)
    plot(val,estimate=c(1,1),se=c(2,5),true=c(1,1),
         names=c("Model","Sandwich"))
}
}

