% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{nIds}
\alias{nIds}
\title{Number of trajectories}
\usage{
nIds(object)
}
\arguments{
\item{object}{The \code{lcModel} object.}
}
\value{
An \code{integer} with the number of trajectories on which the \code{lcModel} was fitted.
}
\description{
Get the number of trajectories (strata) that were used for fitting the given \code{lcModel} object.
The number of trajectories is determined from the number of unique identifiers in the training data. In case the trajectory ids were supplied using a \code{factor} column, the number of trajectories is determined by the number of levels instead.
}
\examples{
data(latrendData)
method <- lcMethodRandom("Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)
nIds(model)
}
\seealso{
\link{nobs} \link{nClusters}
}
