% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodCustom.R, R/modelCustom.R,
%   R/methodRandom.R, R/modelPartition.R, R/modelStratify.R,
%   R/modelWeightedPartition.R
\name{interface-custom}
\alias{interface-custom}
\alias{getArgumentDefaults,lcMethodCustom-method}
\alias{getName,lcMethodCustom-method}
\alias{getShortName,lcMethodCustom-method}
\alias{prepareData,lcMethodCustom-method}
\alias{fit,lcMethodCustom-method}
\alias{getName,lcModelCustom-method}
\alias{getShortName,lcModelCustom-method}
\alias{converged,lcModelCustom-method}
\alias{postprob,lcModelCustom-method}
\alias{predict.lcModelCustom}
\alias{predictPostprob,lcModelCustom-method}
\alias{clusterTrajectories,lcModelCustom-method}
\alias{fittedTrajectories,lcModelCustom-method}
\alias{getArgumentDefaults,lcMethodRandom-method}
\alias{getName,lcMethodRandom-method}
\alias{getShortName,lcMethodRandom-method}
\alias{fit,lcMethodRandom-method}
\alias{clusterTrajectories,lcModelPartition-method}
\alias{converged,lcModelPartition-method}
\alias{getName,lcModelPartition-method}
\alias{getShortName,lcModelPartition-method}
\alias{postprob,lcModelPartition-method}
\alias{converged,lcModelStratify-method}
\alias{predictPostprob,lcModelStratify-method}
\alias{clusterTrajectories,lcModelWeightedPartition-method}
\alias{converged,lcModelWeightedPartition-method}
\alias{getName,lcModelWeightedPartition-method}
\alias{getShortName,lcModelWeightedPartition-method}
\alias{postprob,lcModelWeightedPartition-method}
\title{custom interface}
\usage{
\S4method{getArgumentDefaults}{lcMethodCustom}(object)

\S4method{getName}{lcMethodCustom}(object)

\S4method{getShortName}{lcMethodCustom}(object)

\S4method{prepareData}{lcMethodCustom}(method, data, verbose)

\S4method{fit}{lcMethodCustom}(method, data, envir, verbose)

\S4method{getName}{lcModelCustom}(object, ...)

\S4method{getShortName}{lcModelCustom}(object, ...)

\S4method{converged}{lcModelCustom}(object, ...)

\S4method{postprob}{lcModelCustom}(object, ...)

\method{predict}{lcModelCustom}(object, ..., newdata = NULL, what = "mu")

\S4method{predictPostprob}{lcModelCustom}(object, newdata = NULL, ...)

\S4method{clusterTrajectories}{lcModelCustom}(object, at = time(object), ...)

\S4method{fittedTrajectories}{lcModelCustom}(
  object,
  at = time(object),
  what = "mu",
  clusters = trajectoryAssignments(object),
  ...
)

\S4method{getArgumentDefaults}{lcMethodRandom}(object)

\S4method{getName}{lcMethodRandom}(object)

\S4method{getShortName}{lcMethodRandom}(object)

\S4method{fit}{lcMethodRandom}(method, data, envir, verbose, ...)

\S4method{clusterTrajectories}{lcModelPartition}(
  object,
  at = time(object),
  center = object@center,
  approxFun = approx,
  ...
)

\S4method{converged}{lcModelPartition}(object, ...)

\S4method{getName}{lcModelPartition}(object, ...)

\S4method{getShortName}{lcModelPartition}(object, ...)

\S4method{postprob}{lcModelPartition}(object, ...)

\S4method{converged}{lcModelStratify}(object, ...)

\S4method{predictPostprob}{lcModelStratify}(object, newdata = NULL, ...)

\S4method{clusterTrajectories}{lcModelWeightedPartition}(
  object,
  at = time(object),
  center = weighted.meanNA,
  approxFun = approx,
  ...
)

\S4method{converged}{lcModelWeightedPartition}(object, ...)

\S4method{getName}{lcModelWeightedPartition}(object, ...)

\S4method{getShortName}{lcModelWeightedPartition}(object, ...)

\S4method{postprob}{lcModelWeightedPartition}(object, ...)
}
\arguments{
\item{object}{The \code{lcMethod} or \code{lcModel} object.}

\item{method}{An object inheriting from \code{lcMethod} with all its arguments having been evaluated and finalized.}

\item{data}{A \code{data.frame} representing the transformed training data.}

\item{verbose}{A \link[R.utils:Verbose]{R.utils::Verbose} object indicating the level of verbosity.}

\item{envir}{The \code{environment} containing variables generated by \code{\link[=prepareData]{prepareData()}} and \code{\link[=preFit]{preFit()}}.}

\item{...}{Additional arguments.}

\item{newdata}{Optional data frame for which to compute the posterior probability. If omitted, the model training data is used.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{at}{An optional vector of the times at which to compute the cluster trajectory predictions.}

\item{center}{The function to use to compute the cluster trajectory center at the respective moment in time.}
}
\description{
custom interface
}
\seealso{
\link{lcMethodCustom} \link{lcModelCustom} \link{lcMethodRandom} \link{lcMethodStratify} \link{lcModelPartition} \link{lcModelWeightedPartition}
}
\keyword{internal}
