% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plots.R
\name{mplot_gain}
\alias{mplot_gain}
\title{Cumulative Gain Plot}
\usage{
mplot_gain(
  tag,
  score,
  multis = NA,
  target = "auto",
  splits = 10,
  highlight = "auto",
  caption = NA,
  save = FALSE,
  subdir = NA,
  file_name = "viz_gain.png",
  quiet = FALSE
)
}
\arguments{
\item{tag}{Vector. Real known label.}

\item{score}{Vector. Predicted value or model's result.}

\item{multis}{Data.frame. Containing columns with each category probability
or score (only used when more than 2 categories coexist).}

\item{target}{Value. Which is your target positive value? If
set to 'auto', the target with largest mean(score) will be
selected. Change the value to overwrite. Only works for binary classes}

\item{splits}{Integer. Numer of quantiles to split the data}

\item{highlight}{Character or Integer. Which split should be used
for the automatic conclussion in the plot? Set to "auto" for
best value, "none" to turn off or the number of split.}

\item{caption}{Character. Caption to show in plot}

\item{save}{Boolean. Save output plot into working directory}

\item{subdir}{Character. Sub directory on which you wish to save the plot}

\item{file_name}{Character. File name as you wish to save the plot}

\item{quiet}{Boolean. Do not show message for auto target?}
}
\value{
Plot with gain and performance results by cuts.
}
\description{
The cumulative gains plot, often named ‘gains plot’, helps us
answer the question: When we apply the model and select the best
X deciles, what % of the actual target class observations can we
expect to target? The cumulative gains chart shows the percentage
of the overall number of cases in a given category "gained" by
targeting a percentage of the total number of cases.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dfr) # Results for AutoML Predictions
lapply(dfr, head)

# Plot for Binomial Model
mplot_gain(dfr$class2$tag, dfr$class2$scores,
  caption = "Titanic Survived Model",
  target = "FALSE"
)
mplot_gain(dfr$class2$tag, dfr$class2$scores,
  caption = "Titanic Survived Model",
  target = "TRUE"
)

# Plot for Multi-Categorical Model
mplot_gain(dfr$class3$tag, dfr$class3$score,
  multis = subset(dfr$class3, select = -c(tag, score)),
  caption = "Titanic Class Model"
)
}
\seealso{
Other ML Visualization: 
\code{\link{mplot_conf}()},
\code{\link{mplot_cuts_error}()},
\code{\link{mplot_cuts}()},
\code{\link{mplot_density}()},
\code{\link{mplot_full}()},
\code{\link{mplot_importance}()},
\code{\link{mplot_lineal}()},
\code{\link{mplot_metrics}()},
\code{\link{mplot_response}()},
\code{\link{mplot_roc}()},
\code{\link{mplot_splits}()},
\code{\link{mplot_topcats}()}
}
\concept{ML Visualization}
