% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plots.R
\name{mplot_topcats}
\alias{mplot_topcats}
\title{Top Hit Ratios for Multi-Classification Models}
\usage{
mplot_topcats(tag, score, multis, model_name = NA)
}
\arguments{
\item{tag}{Vector. Real known label.}

\item{score}{Vector. Predicted value or model's result.}

\item{multis}{Data.frame. Containing columns with each category probability
or score (only used when more than 2 categories coexist).}

\item{model_name}{Character. Model's name}
}
\value{
Plot with performance results over most frequent categories.
}
\description{
Calculate and plot a multi-class model's predictions accuracy
based on top N predictions and distribution of probabilities.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dfr) # Results for AutoML Predictions
mplot_topcats(dfr$class3$tag, dfr$class3$score,
  multis = subset(dfr$class3, select = -c(tag, score)),
  model_name = "Titanic Class Model"
)
}
\seealso{
Other ML Visualization: 
\code{\link{mplot_conf}()},
\code{\link{mplot_cuts_error}()},
\code{\link{mplot_cuts}()},
\code{\link{mplot_density}()},
\code{\link{mplot_full}()},
\code{\link{mplot_gain}()},
\code{\link{mplot_importance}()},
\code{\link{mplot_lineal}()},
\code{\link{mplot_metrics}()},
\code{\link{mplot_response}()},
\code{\link{mplot_roc}()},
\code{\link{mplot_splits}()}
}
\concept{ML Visualization}
