% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_metrics.R
\name{gain_lift}
\alias{gain_lift}
\title{Cumulative Gain, Lift and Response}
\usage{
gain_lift(
  tag,
  score,
  target = "auto",
  splits = 10,
  plot = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{tag}{Vector. Real known label}

\item{score}{Vector. Predicted value or model's result}

\item{target}{Value. Which is your target positive value? If
set to 'auto', the target with largest mean(score) will be
selected. Change the value to overwrite. Only used when binary
categorical model.}

\item{splits}{Integer. Number of percentiles to split the data}

\item{plot}{Boolean. Plot results? Uses \code{mplot_gain()}}

\item{quiet}{Boolean. Quiet all messages, warnings, recommendations?}
}
\value{
data.frame when \code{plot=FALSE} or plot when \code{plot=TRUE}.
}
\description{
This function calculates cumulative gain, lift, and response
values for a predictive score of a specific target. You can use the
\code{mplot_gain()} function to create a plot.
}
\examples{
data(dfr) # Results for AutoML Predictions
head(dfr$class2)

# Results for Binomial Model
gain_lift(dfr$class2$tag, dfr$class2$scores, target = "FALSE")
gain_lift(dfr$class2$tag, dfr$class2$scores, target = "TRUE", splits = 5)
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other Model metrics: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{errors}()},
\code{\link{loglossBinary}()},
\code{\link{model_metrics}()}
}
\concept{Machine Learning}
\concept{Model metrics}
