% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.R
\name{fb_rf}
\alias{fb_rf}
\title{Facebook Reach and Frequency API}
\usage{
fb_rf(
  token,
  ad_account = NA,
  prediction = NA,
  objective = "REACH",
  days = 28,
  budget = 2e+06,
  destination_ids = NA,
  countries = "MX",
  frequency_cap = 8,
  prediction_mode = 1,
  curve = TRUE,
  api_version = "v12.0",
  process = TRUE,
  ...
)
}
\arguments{
\item{token}{Character. Valid access token with sufficient privileges. Visit the
\href{https://developers.facebook.com/tools/explorer}{Facebook API Graph Explorer}
to acquire one.}

\item{ad_account}{Character. Ad Account. Remember to start with \code{act_}. If you
use the \code{prediction} argument, no need to provide this parameter.}

\item{prediction}{Integer. Prediction ID if you already created the prediction
and wish to query the curve's data. As this prediction already exists, the
rest of arguments of this function will be ignored.}

\item{objective}{Character. Any of: "BRAND_AWARENESS", "LINK_CLICKS", "POST_ENGAGEMENT",
"MOBILE_APP_INSTALLS", "CONVERSIONS", "REACH", or "VIDEO_VIEWS".}

\item{days}{Integer. Amount of days for your campaign's predictions.}

\item{budget}{Integer. The budget in the Ad Account currency in cents.}

\item{destination_ids}{Integer vector. Page ID and/or Instagram Account ID.}

\item{countries}{Character vector. Country's acronyms.}

\item{frequency_cap}{Integer. Frequency cap over all the campaign duration.}

\item{prediction_mode}{Integer. "1" for predicting Reach by providing budget,
"2" is for predicting Budget given a specific Reach.}

\item{curve}{Boolean. Return curve data? If not, only prediction will be created.}

\item{api_version}{Character. Facebook API version}

\item{process}{Boolean. Process GET results to a more friendly format?}

\item{...}{Additional parameters passed to target specs.}
}
\value{
data.frame with un-nested processed results if \code{process=TRUE} or
raw API results as list when \code{process=FALSE}.
}
\description{
Create or query reach and frequency predictions using Facebook's
Reach and Frequency API. For more information on the API and its parameters, go to the
\href{https://developers.facebook.com/docs/marketing-api/insights}{original documentaion}.
}
\examples{
\dontrun{
token <- "YOURTOKEN"
account_id <- "act_20846447"

# BASIC 1: Create and return data for a new prediction
basic1 <- fb_rf(token, account_id, destination_ids = 187071108930, countries = "AR")

# BASIC 2: Fetch data for an existing prediction ID
basic2 <- fb_rf(token, account_id, prediction = 6260368700774)

# ADVANCED (Fully custom prediction)
advanced <- fb_rf(token, account_id,
  objective = "REACH",
  days = 28,
  budget = 2000000,
  destination_ids = c(187071108930, 1142958119078556),
  age_min = 15,
  age_max = 65,
  genders = 2,
  countries = "MX",
  publisher_platforms = c(
    "facebook",
    "instagram",
    #' audience_network',
    "messenger"
  ),
  # interests_ids = NA,
  facebook_positions = c(
    "feed",
    #' instant_article',
    "marketplace",
    "video_feeds",
    "story",
    "search",
    "instream_video"
  ),
  instagram_positions = c(
    "stream",
    "story",
    "explore"
  ),
  # audience_network_positions = c(
  #  'classic',
  #  'instream_video')
  messenger_positions = c(
    "messenger_home",
    "sponsored_messages",
    "story"
  ),
  device_platforms = c(
    "mobile",
    "desktop"
  )
)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_posts}()},
\code{\link{fb_post}()},
\code{\link{fb_process}()},
\code{\link{fb_token}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other Facebook: 
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_posts}()},
\code{\link{fb_post}()},
\code{\link{fb_process}()},
\code{\link{fb_token}()}
}
\concept{API}
\concept{Facebook}
