% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_opts}
\alias{check_opts}
\alias{check_attr}
\title{Validate inputs (attributions, options, ...)}
\usage{
check_opts(
  inputs,
  opts,
  input_name = "input",
  type = "all",
  not = "stop",
  quiet = TRUE
)

check_attr(object, attr = "type", check = NULL, stop = TRUE)
}
\arguments{
\item{inputs}{Vector character. Check options.}

\item{opts}{Vector character. Valid options.}

\item{input_name}{Character. Custom your message and change "input"
for any other string. For example: "column names".}

\item{type}{Character. Options: "all", "any."}

\item{not}{Character. Options: "stop", "message", "print", "return".}

\item{quiet}{Boolean. Keep quiet? If not, returns logical value.}

\item{object}{Object of any kind}

\item{attr}{Character. Attribute to check}

\item{check}{Character. Attribute value}

\item{stop}{Boolean. Stop if doesn't check?}
}
\value{
Boolean. Result of \code{inputs} in \code{opts} (options).
Depending on \code{type} and/or \code{stop} arguments,
errors or messages will be shown.

No return value, called for side effects.
}
\description{
This function validates if inputs match all/any of your options
and return error/message with possible options to use.

This function checks if an object has a specific attribute and
stops if not.
}
\examples{
opts <- c("A", "B", "C")
# Let's check the "all" logic
check_opts(inputs = c("A", "B"), opts, quiet = FALSE)
check_opts(inputs = c("X"), opts, not = "message", quiet = FALSE)
check_opts(inputs = c("A", "X"), opts, input_name = "value", not = "warning")
# Now let's check the "any" logic
check_opts(inputs = c("A", "X"), opts, type = "any")
check_opts(inputs = c("X"), opts, type = "any", not = "message")
check_opts(inputs = c("A", NA), opts, type = "any")
# Final trick: just ignore results
check_opts(inputs = "X", opts, not = "invisible")
test <- data.frame()
attributes(test)
check_attr(test, "class", "data.frame")
# check_attr(test, "class", "not.data.frame")
}
