% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_plots.R
\name{plot_chord}
\alias{plot_chord}
\title{Chords Plot}
\usage{
plot_chord(
  origin,
  dest,
  weight = 1,
  mg = 3,
  title = "Chord Diagram",
  subtitle = "",
  pal = NA
)
}
\arguments{
\item{origin, dest}{Vectors. Origin and destination vectors}

\item{weight}{Vector. Weight for each chord.}

\item{mg}{Numeric. Margin adjust for plot in case of need}

\item{title}{Character. Title for the plot}

\item{subtitle}{Character. Subtitle for the plot}

\item{pal}{Vector. Colour pallete. Order matters.}
}
\value{
chordDiagram object
}
\description{
This auxiliary function plots discrete and continuous values results
}
\examples{
# You must have "circlize" library to use this auxiliary function:
\dontrun{
df <- data.frame(from = c(1, 1, 2, 3, 4, 1, 6), to = c(4, 4, 4, 2, 2, NA, NA))
plot_chord(df$from, df$to)
}
}
\seealso{
Other Visualization: 
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{noPlot}()},
\code{\link{plot_survey}()},
\code{\link{plot_timeline}()},
\code{\link{tree_var}()}
}
\concept{Visualization}
