% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{glued}
\alias{glued}
\title{Interpolate a string [glue wrapper]}
\usage{
glued(..., .sep = "", .envir = parent.frame())
}
\arguments{
\item{...}{[\code{expressions}]\cr Expressions string(s) to format, multiple inputs are concatenated together before formatting.}

\item{.sep}{[\code{character(1)}: \sQuote{""}]\cr Separator used to separate elements.}

\item{.envir}{[\code{environment}: \code{parent.frame()}]\cr Environment to evaluate each expression in. Expressions are
evaluated from left to right. If \code{.x} is an environment, the expressions are
evaluated in that environment and \code{.envir} is ignored.}
}
\value{
Same as input but transformed (glued).
}
\description{
Format and interpolate a string using a \code{glue} wrapper. Allows
simple operations, \code{NULL} values as input, and interactions with
internal (created within \code{glued}) and external (environment) objects.
}
\examples{
name <- "Bernardo"
age <- 29
anniversary <- as.Date("2016-04-30")
glued("
  My name is {name},
  my age next year will be {age + 1},
  and I got married on {format(anniversary, '\%A, \%B \%d, \%Y')}.")

# Single braces can be inserted by doubling them
glued("My name is {name}, not {{name}}.")

# You can also used named arguments
glued(
  "Her name is {name}, ",
  "and her age next year will be {age + 1}.",
  name = "Maru",
  age = 6)
  
# And run operations with memories (beware!)
glued("My name, {name}, has {n <- nchar(name); n} characters.
       If we multiply by ten, we'll have {10 * n} characters!")

# If you pass a vector, the operation will be repeated for each element
glued("Here's the value #{1:3}")
}
