% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_landscape.R
\name{show_landscape}
\alias{show_landscape}
\alias{show_landscape.RasterLayer}
\alias{show_landscape.list}
\alias{show_landscape.RasterStack}
\alias{show_landscape.RasterBrick}
\title{show_landscape}
\usage{
show_landscape(x, xlab, ylab, discrete, unique_scales, n_col, n_row, ...)

\method{show_landscape}{RasterLayer}(x, xlab = "Easting",
  ylab = "Northing", discrete = FALSE, ...)

\method{show_landscape}{list}(x, xlab = "Easting", ylab = "Northing",
  discrete = FALSE, unique_scales = FALSE, n_col = NULL,
  n_row = NULL, ...)

\method{show_landscape}{RasterStack}(x, xlab = "Easting",
  ylab = "Northing", discrete = FALSE, unique_scales = FALSE,
  n_col = NULL, n_row = NULL, ...)

\method{show_landscape}{RasterBrick}(x, xlab = "Easting",
  ylab = "Northing", discrete = FALSE, unique_scales = FALSE,
  n_col = NULL, n_row = NULL, ...)
}
\arguments{
\item{x}{Raster* object}

\item{xlab}{x axis label, default "Easting"}

\item{ylab}{y axis label, default "Northing"}

\item{discrete}{If TRUE, the function plots a raster with
a discrete legend.}

\item{unique_scales}{If TRUE and multiple raster are to be visualized, each facet can have a unique color scale for its fill}

\item{n_col}{If multiple rasters are to be visualized, n_col controls the number of columns for the facet}

\item{n_row}{If multiple rasters are to be visualized, n_row controls the number of rows for the facet}

\item{...}{Arguments for  \code{\link{theme_nlm}}}
}
\value{
ggplot2 Object
}
\description{
Plot a Raster* object with the NLMR default theme (as ggplot).
}
\examples{
\dontrun{
x <- gradient_landscape

# classify
y <- util_classify(gradient_landscape,
                   n = 3,
                   level_names = c("Land Use 1", "Land Use 2", "Land Use 3"))

show_landscape(x)
show_landscape(y, discrete = TRUE)

show_landscape(list(gradient_landscape, random_landscape))
show_landscape(raster::stack(gradient_landscape, random_landscape))

show_landscape(list(gradient_landscape, y), unique_scales = TRUE)

}

}
