% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_cai_cv.R
\name{lsm_c_cai_cv}
\alias{lsm_c_cai_cv}
\title{CAI_CV (class level)}
\usage{
lsm_c_cai_cv(
  landscape,
  directions = 8,
  consider_boundary = FALSE,
  edge_depth = 1
)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape
boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch
edge to be considered as core cell}
}
\value{
tibble
}
\description{
Coefficient of variation of core area index (Core area metric)
}
\details{
\deqn{CAI_{CV} = cv(CAI[patch_{ij}]}
where \eqn{CAI[patch_{ij}]} is the core area index of each patch.

CAI_CV is a 'Core area metric'. The metric summarises each class
as the Coefficient of variation of the core area index of all patches
belonging to class i. The core area index is the percentage of core area
in relation to patch area. A cell is defined as core area if the cell has
no neighbour with a different value than itself (rook's case). The metric
describes the differences among patches of the same class i in
the landscape. Because it is scaled to the mean, it is easily comparable.

\subsection{Units}{Percent}
\subsection{Range}{CAI_CV >= 0}
\subsection{Behaviour}{Equals CAI_CV = 0 if the core area index is identical
for all patches. Increases, without limit, as the variation of the core area
indices increases.}
}
\examples{
lsm_c_cai_cv(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
\seealso{
\code{\link{lsm_p_cai}},
\code{\link{cv}}, \cr
\code{\link{lsm_c_cai_mn}},
\code{\link{lsm_c_cai_sd}}, \cr
\code{\link{lsm_l_cai_mn}},
\code{\link{lsm_l_cai_sd}},
\code{\link{lsm_l_cai_cv}}
}
