% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-handling.R
\name{stop_html}
\alias{stop_html}
\title{Raise an error with an optional HTML status code for API Gateways}
\usage{
stop_html(..., code = 500L)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character (and which
are pasted together with no separator). This forms the error message.}

\item{code}{HTTP status code to return (if applicable). Defaults to \code{500},
which is a generic "Internal Server Error". This is used when errors are to
be returned to an API Gateway.}
}
\description{
This variation of \code{stop} can be used to raise an error with a specific error
code. This is provided to the API Gateway to return an appropriate response.
It had no use outside of invocations via an API Gateway.

If a status code is not provided, a generic "500" internal server error will
be used.
}
\examples{
\dontrun{
stop_html("Resource doesn't exist", code = 404L)
}
}
