% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeSurroundTopo.R
\name{lakeSurroundTopo}
\alias{lakeSurroundTopo}
\title{Calculate surrounding topography for lake}
\usage{
lakeSurroundTopo(
  inLake,
  inElev = NULL,
  inCatch = NULL,
  reso = ifelse(!is.null(inElev), res(inElev)[1], 10)
)
}
\arguments{
\item{inLake}{a SpatialPolygons or SpatialPolygonsDataFrame representing the input lake. Required.}

\item{inElev}{a RasterLayer representing the elevation around the lake. Required.}

\item{inCatch}{Optional SpatialPolygons or SpatialPolygonsDataFrame defining the
Surrounding Topography.  Default is NULL which uses a buffer equal to the
maximum in lake distance.}

\item{reso}{Optional resolution for raster output (e.g. lake distance).
Defaults to the resolution of inElev}
}
\value{
Returns an object of class 'lakemorpho' that includes the surrounding
        topography of the lake.
}
\description{
This function combines all input datasets into a \code{\link{lakeMorphoClass}}.
As a part of this combination, the surrounding topography is also determined.
If no input catchments are used, it is assumed that a buffer equal to the
maximum in lake distance is used. If an input catchement is used, then the
surrounding topography is the land area represented by the  catchements that
intersect the lake. This function (and all of \code{lakemorpho}) expect clean
polygons.  No internal checking (e.g. for proper encoding of holes, etc.) is
done.
}
\examples{
\donttest{
data(lakes)
inputLM<-lakeSurroundTopo(exampleLake,exampleElev)
inputLM
}

}
