% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thumbnail.R
\name{view_slide}
\alias{view_slide}
\title{Preview Slide as Image}
\usage{
view_slide(presentation_id, page, size = "MEDIUM", viewer = TRUE)
}
\arguments{
\item{presentation_id}{character, the presentation id}

\item{page}{character, the page number or id}

\item{size}{character, the size of the image. One of "SMALL", "MEDIUM",
"LARGE"}

\item{viewer}{logical, if TRUE opens the image in the viewer}
}
\value{
A character string of the file path to the saved image and
opens the image in the viewer or browser if \code{viewer = TRUE}.
}
\description{
Preview Slide as Image
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
s <- choose_slides()
tmp_image <- view_slide(s, 1)
file.remove(tmp_image)
\dontshow{\}) # examplesIf}
}
