% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isbinarymap.R
\name{isbinarymap}
\alias{isbinarymap}
\title{Test if an \code{im} object is a binary map}
\usage{
isbinarymap(xi, requiretrue = FALSE)
}
\arguments{
\item{xi}{an image object}

\item{requiretrue}{Logical. If TRUE then \code{isbinarymap} will error if xi is NOT a binary map.}
}
\value{
Logical value. \code{TRUE} if \code{xi} is a binary map. Otherwise \code{FALSE}.
If \code{requiretrue = TRUE} and \code{xi} is not a binary map then an error will occur.
}
\description{
Tests whether \code{xi} is a binary map.
The pixel values must be of logical type (\code{TRUE}, \code{FALSE} and \code{NA} only), or numerical (1, 0 or \code{NA}).
}
\examples{
# The following return TRUE
isbinarymap(as.im(heather$coarse, na.value = 0))
isbinarymap(as.im(heather$coarse, na.value = FALSE, value = TRUE))

# The following return FALSE
isbinarymap(as.im(heather$coarse, na.value = 0.2, value = 1))
isbinarymap(as.im(heather$coarse, na.value = 0, value = 1.5))
}
