% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-dmax.R
\name{method_dmax}
\alias{method_dmax}
\title{Dmax}
\usage{
method_dmax(data_prepared, sport, loglog_restrainer = 1, plot)
}
\arguments{
\item{data_prepared}{The data retrieved from \code{prepare_data()}.}

\item{sport}{The sport at which the incremental test was performed. One of \code{cycling}, \code{running}, or \code{swimming}.}

\item{loglog_restrainer}{A scalar from 0 to 1 indicating the percentage of the data that you would like to
restrain for fitting the Log-Log method - This is going to be used in the \code{Log-Poly-ModDmax} and \code{Log-Exp-ModDmax} methods only.
For example, \code{1} means no restriction (fits using the whole data), and \code{0.5} means that
only the first 50\% of the data will be used. Default to \code{1}.}

\item{plot}{A boolean to indicate whether to generate a plot from each one of the methods.
\subsection{Fit}{

The \code{method_dmax()} function does not have a \code{fit} argument because all the \code{Dmax} methods have their own default fitting methods:
\itemize{
\item Dmax = 3rd degree polynomial
\item ModDmax = 3rd degree polynomial
\item Exp-Dmax = exponential
\item Log-Poly-ModDmax = 3rd degree polynomial
\item Log-Exp-ModDmax = exponential
}
}}
}
\value{
a \link[tibble:tibble-package]{tibble} with the following columns:
\item{method}{the method used to estimate the lactate threshold}
\item{fitting}{the fitting method used to predict the lactate curve}
\item{intensity}{the intensity associated with the estimated lactate threshold}
\item{lactate}{the lactate concentration associated with the estimated lactate threshold}
\item{heart_rate}{the heart rate associated with the estimated lactate threshold}
\item{plot}{the plot produced to display the lactate threshold}
}
\description{
It applies the \code{Dmax} methods: \code{"Dmax"}, \code{"ModDmax"}, \code{"Exp-Dmax"}, \code{"Log-Poly-ModDmax"}, and \code{"Log-Exp-ModDmax"}.
}
\keyword{internal}
