% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_avl_labs.R, R/has_quant_labs.R
\name{has_avl_labs}
\alias{has_avl_labs}
\alias{h11l}
\alias{hql}
\title{Is This a \code{add_val_labs()}-style Value-labeled Variable (Column)?}
\usage{
has_avl_labs(data, var)

h11l(data, var)

hql(data, var)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the variable (column) to check for the
presence of \code{add_val_labs()}-style (one-to-one) value labels.}
}
\value{
A 1L logical.
}
\description{
Determine whether a specific variable of a data.frame has value labels
associated with it that were added using \code{add_val_labs()} or \code{add_val1()}.
}
\details{
\code{h11l} is a compact alias for \code{has_avl_labs}: they do the same thing, and the
former is easier to type
}
\examples{
# add val labs to multiple variables at once
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "y" in their name, except "y3"
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("y"), # note the vars args
  not.vars = "y3",
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

has_avl_labs(dflik, y1) # TRUE

has_avl_labs(dflik, y3) # FALSE, see not.vars arg above
}
