% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_labeled_data_frame.R
\name{as_labeled_data_frame}
\alias{as_labeled_data_frame}
\alias{aldf}
\title{Assign Class labeled.data.frame to a Data Frame Object}
\usage{
as_labeled_data_frame(data, fact.to.char = FALSE, irreg.to.na = FALSE)

aldf(data, fact.to.char = FALSE, irreg.to.na = FALSE)
}
\arguments{
\item{data}{a data.frame object.}

\item{fact.to.char}{coerce all factor variables to character variables.}

\item{irreg.to.na}{convert all irregular values (see \code{irregular2v()}) to NA.}
}
\value{
an object of classes labeled.data.frame and data.frame, with any
additional classes removed.
}
\description{
\code{as_labeled_data_frame} quietly assigns the class labeled.data.frame to a
data.frame and discards other augmented data.frame classes, returning a
data.frame with classes labeled.data.frame and data.frame.
}
\details{
Note 1: \code{aldf} is a compact alias for \code{as_labeled_data_frame}: they do the same
thing, and the former is easier to type

Note 2: \code{as_labeled_data_frame} is used internally by other labelr commands
and is not intended for interactive use.

To minimize dependencies and complexities, labelr label-assigning
functions are designed to work exclusively with Base R data.frames, not
alternative data structures like matrices or augmented data.frames, such as
data.tables or tibbles.

\code{as_labeled_data_frame} determines whether data argument is a conventional
Base R data.frame, some kind of augmented data.frame (e.g., data.table,
tibble), or not a data.frame at all (e.g., matrix). If the submitted object
is a type of data.frame, the object will be returned with the class
labeled.data.frame applied, the class data.frame retained, and any other
previous class attributes discarded. If the supplied object is not any kind
of data.frame (i.e., a matrix is not any kind of data.frame, while a data.table
is a kind of data.frame), an error is thrown.
}
\examples{
x1 <- runif(10)
x2 <- as.character(sample(c(1:20), 10, replace = TRUE))
x3 <- sample(letters, size = 10, replace = TRUE)
df <- data.frame(x1, x2, x3)
dft <- tibble::as_tibble(df)
class(dft)
dfl <- as_labeled_data_frame(dft)
class(dfl)
}
