% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_frame_lab.R
\name{drop_frame_lab}
\alias{drop_frame_lab}
\alias{dfl}
\title{Remove Frame Label Attribute from a Data Frame}
\usage{
drop_frame_lab(data)

dfl(data)
}
\arguments{
\item{data}{the data.frame with a frame label that you wish to drop (and which
was added using \code{add_frame_lab}).}
}
\value{
a data.frame (with any previously applied frame.lab attribute removed).
}
\description{
Remove the frame label attribute (see \code{add_frame_lab}) from a data.frame, if
one is present.
}
\details{
See \code{add_frame_lab} for more on this labeling construct.

Note: \code{dfl} is a compact alias for \code{drop_frame_lab}: they do the same thing,
and the former is easier to type.
}
\examples{
# add frame.lab to mtcars and assign to new data.frame mt2
mt2 <- add_frame_lab(mtcars, frame.lab = "Data extracted from the 1974 Motor
                    Trend US magazine, comprising fuel consumption and 10
                    aspects of automobile design and performance for 32
                    automobiles (1973–74 models). Source: Henderson and
                    Velleman (1981), Building multiple regression models
                    interactively. Biometrics, 37, 391–411.")

get_frame_lab(mt2) # return frame.lab alongside data.frame name as a data.frame
drop_frame_lab(mt2) # remove this frame.lab
get_frame_lab(mt2) # the data.frame name now doubles as its frame label
is.null(attributes(data)[["frame.lab"]]) # the attribute is NULL
}
