% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_label.R
\name{var_label}
\alias{var_label}
\alias{var_label<-}
\alias{set_variable_labels}
\title{Get / Set a variable label}
\usage{
var_label(x)

var_label(x) <- value

set_variable_labels(.data, ...)
}
\arguments{
\item{x}{An object.}

\item{value}{A character string or \code{NULL} to remove the label. For data frames,
it could also be a named list.}

\item{.data}{a data frame}

\item{...}{name-value pairs of variable labels (see examples)}
}
\value{
\code{set_variable_labels} will return an updated copy of \code{.data}.
}
\description{
Get / Set a variable label
}
\details{
For data frames, if \code{value} is a named list, only elements whose name will
  match a column of the data frame will be taken into account.
}
\note{
\code{set_variable_labels} could be used with \code{dplyr}.
}
\examples{
var_label(iris$Sepal.Length)
var_label(iris$Sepal.Length) <- 'Length of the sepal'
\dontrun{
 View(iris)
}
# To remove a variable label
var_label(iris$Sepal.Length) <- NULL
if (require(dplyr)) {
  # adding some variable labels
  df <- data_frame(s1 = c("M", "M", "F"), s2 = c(1, 1, 2)) \%>\%
    set_variable_labels(s1 = "Sex", s2 = "Yes or No?")
  var_label(df)

  # removing a variable label
  df <- df \%>\% set_variable_labels(s2 = NULL)
  var_label(df$s2)
}
}
