% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkCoercion.R
\name{checkCoercion}
\alias{checkCoercion}
\title{Check if values can be safely coerced without introduction of
missing values}
\usage{
checkCoercion(value, targetclass, na.strings = c("\\\\.", "", "\\\\s+", "N/A"))
}
\arguments{
\item{value}{Character vector of values, such as value_new or
value_old for one variable in a key.}

\item{targetclass}{R class name}

\item{na.strings}{Values that should be interpreted as R NA.
These are ignored in the coercion check.}
}
\value{
either TRUE, or a vector of values which are not
    successfully coerced
}
\description{
This might be named "coercesSafely" or such.  If values cannot be
coerced into class specified, then values must be incorrect.
}
\examples{
x1 <- c("TRUE", "FALSE", FALSE, TRUE, NA, ".", "N/A", " ", "")
checkCoercion(x1, "logical")
x1 <- c(x1, "TRUE.FALSE", "Has a space")
## Should fail:
checkCoercion(x1, "logical")
x2 <- c(4, 5, 6, 9.2, ".", " ")
## Should fail
checkCoercion(x2, "logical")
x3 <- factor(c("bob", "emily", "bob", "jane", "N/A", " ", NA, "NA"))
checkCoercion(x3, "ordered")
checkCoercion(x3, "integer")
## Should fail:
checkCoercion(x3, "logical")

}
\author{
Paul Johnson <pauljohn@ku.edu>
}
