% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mgsub}
\alias{mgsub}
\title{apply a vector of replacements, one after the other.}
\usage{
mgsub(pattern, replacement, x, ...)
}
\arguments{
\item{pattern}{vector of values to be replaced. A vector filled
with patterns as documented in the \code{gsub} pattern
argument}

\item{replacement}{vector of replacements, otherwise same as
\code{gsub}.  Length of replacement must be either 1 or same
as pattern, otherwise an error results.}

\item{x}{the vector in which elements are to be replaced, same as
\code{gsub}}

\item{...}{Additional arguments to be passed to gsub}
}
\value{
vector with pattern replaced by replacement
}
\description{
This is multi-gsub.  Use it when it is necessary to process
many patterns and replacements in a given order on a vector.
}
\examples{
x <- c("Tom", "Jerry", "Elmer", "Bugs")
pattern <- c("Tom", "Bugs")
replacement <- c("Thomas", "Bugs Bunny")
(y <- mgsub(pattern, replacement, x))
x[1] <- "tom"
(y <- mgsub(pattern, replacement, x, ignore.case = TRUE))
(y <- mgsub(c("Elmer", "Bugs"), c("Looney Characters"), x, ignore.case = TRUE))
}
\author{
Jared Harpole <jared.harpole@gmail.com> and Paul Johnson
    <pauljohn@ku.edu>
}

