% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{cleanDataFrame}
\alias{cleanDataFrame}
\title{Check and Clean data.frame for usage with variable key functions}
\usage{
cleanDataFrame(dframe, safeNumericToInteger = TRUE)
}
\arguments{
\item{dframe}{A data frame}

\item{safeNumericToInteger}{Default TRUE: Should we treat values
which appear to be integers as integers? If a column is
numeric, it might be safe to treat it as an integer.  In many
csv data sets, the values coded c(1, 2, 3) are really
integers, not floats c(1.0, 2.0, 3.0). See
\code{safeInteger}.}
}
\value{
A checked and cleaned data frame
}
\description{
Checks that the data.frame is made up of simple individual
columns. Checks numeric columns to find out if they are
acceptable to treat as integers. If they are acceptable to
treat as integers, then convert those numeric to integer class
variables.
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
\keyword{internal}

