globalVariables("jgd2011_bbox")

#' JGD2011 / Japan Plane Rectangular CS
#'
#' @description Japanese Geodetic Datum 2011
#' @format A sf (CRS EPSG:6668) with 19 rows 3 variables:
#' - system
#' - epsg
#' - geometry
#' @author Original polygon data copyright is the Geospatial Information Authority of Japan;
#' compiled for R by Shinya Uryu.
#' @references Global Map Japan [https://www.gsi.go.jp/kankyochiri/gm_jpn.html](https://www.gsi.go.jp/kankyochiri/gm_jpn.html).
#' Created by processing Global Map Japan.
#' @return [sf][sf::st_sf]
#' @examples
#' require("sf")
#' jgd2011_bbox
"jgd2011_bbox"
