% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmassessbayesian.R
\name{kmassessbayesian}
\alias{kmassessbayesian}
\title{Update probability distribution applying Bayesian update}
\usage{
kmassessbayesian(probs, ks, beta, eta, question, response)
}
\arguments{
\item{probs}{Probability distribution over the knowledge structure (vector)}

\item{ks}{Binary matrix of the knowledge structure}

\item{beta}{Vector of careless error probabilities}

\item{eta}{Vector of lucky guess probabilities}

\item{question}{Item that has been posed}

\item{response}{Correctness of received response (0 or 1)}
}
\value{
Updated probability vector
}
\description{
\code{kmassessbayesian} updates a probability distribution over a
knowledge structure according to the Bayesian update rule.
}
\examples{
kmassessbayesian(c(0.02, 0.1, 0.07, 0.01, 0.4, 0.17, 0.07, 0.08, 0.08),
                 xpl$space,
                 rep(0.2,4),
                 rep(0.1,4),
                 3,
                 1
                )

}
\seealso{
Other Knowledge assessment: 
\code{\link{kmassess}()},
\code{\link{kmassesshalfsplit}()},
\code{\link{kmassessinformative}()},
\code{\link{kmassessmentsimulation}()},
\code{\link{kmassessmultiplicative}()}
}
\concept{Knowledge assessment}
