% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distNumeric.R
\name{distNumeric}
\alias{distNumeric}
\title{A pair distance for continuous variables.}
\usage{
distNumeric(x, y, method = "mrw")
}
\arguments{
\item{x}{A data matrix.}

\item{y}{A second data matrix.}

\item{method}{A  distance for numerical variables.}
}
\description{
This function computes and returns the distance matrix computed by using
the specified distance measure to compute the pairwise distances between the rows of two data
of numerical variables.
}
\details{
This is a two-data-set to compute distance.
It returns a matrix of all pairwise distances between rows in x and y.
The available distance are Manhattan weighted by rank ("mrw"), Squared Euclidean weighted by
variance ("sev"), Squared Euclidean weighted by rank ("ser"), and Squared Euclidean ("se").
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
mrwdist[1:6,1:6]

}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
