% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusmatrix.R
\name{consensusmatrix}
\alias{consensusmatrix}
\title{Consensus matrix from A bootstrap replicate matrix}
\usage{
consensusmatrix(bootdata, nclust, reorder)
}
\arguments{
\item{bootdata}{A matrix of bootstrap replicate (n x b) membership.}

\item{nclust}{The number of clusters}

\item{reorder}{Any clustering algorithm function with the input is a distance and the end result being only membership.}
}
\value{
Function returns a consensus matrix (n x n).
}
\description{
This function create a consensus matrix from a bootstrap
replicate matrix.
}
\details{
This is a function to obtain a consensus matrix from a bootstrap
evaluation for a cluster. The consensus matrix can be further plotted.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
parkboot <- function(x, nclust) {
res <- fastkmed(x, nclust, iterate = 50)
return(res$cluster)
}
irisboot <- clustboot(mrwdist, nclust=3, parkboot, nboot=7)
wardorder <- function(x, nclust) {
res <- hclust(x, method = "ward.D2")
member <- cutree(res, nclust)
return(member)
}
consensusiris <- consensusmatrix(irisboot, nclust = 3, wardorder)
consensusiris[c(1:5,51:55,101:105),c(1:5,51:55,101:105)]

}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
